@extends('admin.layouts.app')
@section('panel')

<div class="row mb-3">
    <div class="col-lg-12 text-end">
        <a href="{{route('admin.category.create')}}" class="btn btn-sm btn--primary">@lang('Add Category')</a>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">

        {{-- search --}}
        <div class="show-filter mb-3 text-end">
        <button type="button" class="btn btn--primary showFilterBtn btn-sm"><i class="las la-filter"></i> @lang('Filter')</button>
        </div>

        <div class="card responsive-filter-card mb-4">
            <div class="card-body">
                <form action="{{route('admin.category.filter')}}" method="get">
                    <div class="d-flex flex-wrap gap-4">
                        <div class="flex-grow-1">
                            <label>@lang('Name')</label>
                            <input type="text" name="name" class="form-control"
                                placeholder="@lang('Type Here')">
                        </div>
                        <div class="flex-grow-1">
                            <label>@lang('Status')</label>
                            <select name="status" class="form-control">
                                <option value="">@lang('Select Status')</option>
                                <option value="1">@lang('Active')</option>
                                <option value="0">@lang('Inactive')</option>
                            </select>
                        </div>
                        <div class="flex-grow-1 align-self-end">
                            <button type="submit" class="btn btn--primary h-40 w-100"><i class="fas fa-check"></i>@lang('Apply')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        {{-- end search --}}

        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>@lang('S/N')</th>
                                <th>@lang('Name')</th>
                                <th>@lang('Icon')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($categories as $key=>$item)
                            <tr>
                                <td>{{$key+1}}</td>
                                <td>{{__($item->name)}}</td>
                                <td> <img src="{{ getImage(getFilePath('category').'/'.@$item->logo)}}" class="rounded" alt="@lang('image')" style="width:32px"> </td>

                                <td> @php echo $item->statusBadge($item->status); @endphp </td>

                                <td>
                                    <a href="{{route('admin.category.edit',$item->id)}}" title="@lang('Edit')" data-id="{{$item->id}}" class="btn btn-sm btn--primary ">
                                        <i class="las la-edit"></i>
                                    </a>
                                    <button title="@lang('Status Change')"
                                     data-id="{{$item->id}}" data-status ="{{$item->status}}"
                                        class="btn btn-sm btn--danger statusChangeBtn">
                                        <i class="fas fa-sync-alt"></i>
                                    </button>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{__($emptyMessage) }}</td>
                            </tr>
                            @endforelse

                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            @if ($categories->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($categories) }}
            </div>
            @endif
        </div><!-- card end -->
    </div>
</div>

{{-- status change modal --}}
<div id="statusChangeModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Status Change Confirmation!')</h5>
                <button type="button" class="close btn btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="{{route('admin.category.status.change')}}" method="POST">
                @csrf
                <div class="modal-body">
                    <input type="hidden" name="id">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="">@lang('Status')</label>
                            <select id="status" name="status" class="form-control">
                                <option @if(1) selected @endif value="1">@lang('Active')</option>
                                <option @if(0) selected @endif value="0">@lang('Inactive')</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary">@lang('Confirm')</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection


@push('script')
<script>
    $('.statusChangeBtn').on('click', function () {
        var modal = $('#statusChangeModal');
        modal.find('input[name=id]').val($(this).data('id'));
        var status = $(this).data('status');
        modal.find('select[name=status]').val(status);
        modal.modal('show');
    });
</script>
@endpush


