@extends('admin.layouts.app')
@section('panel')


<div class="row">
    <div class="col-lg-12">
        {{-- search --}}
        <div class="show-filter mb-3 text-end">
            <button type="button" class="btn btn--primary showFilterBtn btn-sm"><i class="las la-filter"></i>
                @lang('Filter')</button>
        </div>

        <div class="card responsive-filter-card mb-4">
            <div class="card-body">
                <form action="{{route('admin.order.filter')}}" method="get">
                    <div class="d-flex flex-wrap gap-4">
                        <div class="flex-grow-1">
                            <label>@lang('Order Id')</label>
                            <input type="text" name="order_no" class="form-control"
                                placeholder="@lang('Order No')">
                        </div>
                        <div class="flex-grow-1">
                            <label>@lang('Service')</label>
                            <input type="text" name="service" class="form-control"
                                placeholder="@lang('Type Here')">
                        </div>
                        <div class="flex-grow-1">
                            <label>@lang('User Name')</label>
                            <input type="text" name="username" class="form-control"
                                placeholder="@lang('User Name')">
                        </div>
                        <div class="flex-grow-1">
                            <label>@lang('Status')</label>
                            <select name="status" class="form-control">
                                <option value="">@lang('Select Status')</option>
                                <option value="0">@lang('Pending')
                                </option>
                                <option value="1">@lang('Processing')
                                </option>
                                <option value="2">@lang('Completed')
                                </option>
                                <option value="3">@lang('Cancelled')
                                </option>
                                <option value="4">@lang('Refunded')
                                </option>
                            </select>
                        </div>
                        <div class="flex-grow-1 align-self-end">
                            <button type="submit" class="btn btn--primary h-40 w-100"><i class="fas fa-check"></i>@lang('Apply')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        {{-- end search --}}

        @include('admin.components.tabs.order')
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>@lang('Order No')</th>
                                <th>@lang('User Name')</th>
                                <th>@lang('Order Details')</th>
                                <th>@lang('Price')</th>
                                <th>@lang('Time')</th>
                                 <th>@lang('Api Order')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($orders as $item)
                            <tr>
                                <td>#{{__($item->order_no)}}</td>
                                <td>{{__($item->user->username) }}</td>

                                <td class="text-start">
                                    <span>@lang('Service'):
                                        @if(strlen(__(@$item->service->name)) >50)
                                        {{substr( __(@$item->service->name), 0,50).'...' }}
                                        @else
                                        {{__(@$item->service->name)}}
                                        @endif
                                    </span>
                                    <br>
                                    <span>@lang('Link'): <a href="{{$item->link}}" target="_blank">{{$item->link}}</a> </span>
                                    <br>
                                    <span>@lang('Start Count'):{{$item->start_count??0}}</span>
                                    <br>
                                    <span>@lang('Remain Count'):{{$item->remain_count??0}}</span>
                                </td>

                                <td>{{$general->cur_sym}}{{ showAmount($item->price) }}</td>

                                <td>{{ showDateTime($item->created_at) }}</td>

                                <td>
                                    @if ($item->api_order)
                                        <span class="badge  badge--primary">@lang('Yes')</span>
                                    @else
                                        <span class="badge  badge--warning">@lang('No')</span>
                                    @endif
                                </td>

                                <td>
                                    @php
                                        echo $item->statusBadge($item->status);
                                    @endphp
                                </td>

                                <td>
                                    <a href="{{route('admin.order.edit',$item->id)}}" title="@lang('Edit')"
                                     data-id="{{$item->id}}" data-start_count="{{$item->start_count}}" data-remain_count="{{$item->remain_count}}"
                                     data-status="{{$item->status}}"
                                        class="btn btn-sm btn--primary countUpdate">
                                        <i class="las la-edit"></i>
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{__($emptyMessage) }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            @if ($orders->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($orders) }}
            </div>
            @endif
        </div><!-- card end -->
    </div>
</div>

@endsection

