@extends('admin.layouts.app')
@section('panel')
<div class="row mb-3">
    <div class="col-lg-12">
        <div class="d-flex flex-wrap gap-4 justify-content-end">
            <button type="button" class="btn btn-sm btn--primary mr-3 importbulkServiceBtn" data-toggle="modal" data-target="#importServiceModal" data-route="{{ route('admin.services.import.multi') }}"> @lang('Import Bulk Service')</button>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>@lang('ID')</th>
                                <th>@lang('Name')</th>
                                <th>@lang('Category')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($apiServiceLists as $service)
                            <tr>
                                <td>{{__($service->service)}}</td>
                                <td>{{\Str::limit($service->name, 30)}}</td>
                                <td>{{$service->category}}</td>
                                <td>
                                    <button  data-route="{{ route('admin.services.import.single',['id'=>$service->service,'name'=>$service->name,'category'=>$service->category,'rate'=>$service->rate, 'dripfeed'=>@$service->dripfeed, 'min'=>$service->min,'max'=>$service->max,'provider'=>$provider->id]) }}" class="btn btn--primary btn-sm singleServiceImportBtn"> <i class="fas fa-plus"></i>@lang('Add')</button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table><!-- table end -->
                </div>
                <div class="p-5">
                    @if($apiServiceLists->hasPages())
                    <div class="card-footer">
                        {{ paginateLinks($apiServiceLists) }}
                    </div>
                @endif
                </div>
            </div>
        </div><!-- card end -->
    </div>
</div>

{{-- import bulk service --}}
<div class="modal fade" id="importbulkServiceModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Bulk Service Imported')</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="" method="post" id="importMultipleForm">
                @csrf
                <input type="hidden" name="provider_id" value="{{$provider->id}}">
                <div class="modal-body">
                    <p>@lang('Are you really want to Import Service')</p>
                    <div class="form-group">
                        <label>@lang('Bulk add limit')</label>
                        <select class="form-control" name="import_quantity">
                            @for($loop = 25; $loop <= 1000; $loop+=25)
                                <option value="{{ $loop }}">{{ $loop }}</option>
                            @endfor
                            <option value="all">@lang('All Services')</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>@lang('how much percentage increase to apply to the base price?') <span class="text-danger">(@lang('default 10%'))</span> </label>
                        <input type="text" name="percentage" class="form-control" placeholder="%">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary"><i class="fas fa-search"></i> @lang('Confirm Import')</button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- single service Import --}}
<div class="modal fade" id="singleServiceImportModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Bulk Service Imported')</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="" method="post" id="singleimportMultipleForm">
                @csrf
                <input type="hidden" name="provider_id" value="{{$provider->id}}">
                <div class="modal-body">
                    <p>@lang('Are you really want to Import Service')</p>
                    <div class="form-group">
                        <label>@lang('Select Percentage Increase')</label>
                        <select class="form-control" name="price_percentage_increase">
                            @for($percentage = 1; $percentage <= 100; $percentage++)
                            <option value="{{ $percentage }}">{{ $percentage }} %</option>
                            @endfor
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary"><i class="fas fa-search"></i> @lang('Confirm Import')</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('script')
<script>

        $(document).ready(function () {
            'use strict'
             // bulk service import
            $('.importbulkServiceBtn').on('click', function () {
                var modal = $('#importbulkServiceModal');
                let route = $(this).data('route');
                $('#importMultipleForm').attr('action', route);
                modal.modal('show');
            });

            // single service Import
            $('.singleServiceImportBtn').on('click', function () {
                var modal = $('#singleServiceImportModal');
                let route = $(this).data('route');
                $('#singleimportMultipleForm').attr('action', route);
                modal.modal('show');
            });

        });
</script>
@endpush

