@extends($activeTemplate.'layouts.master')
@section('content')
<div class="col-xl-9 col-lg-12">
    <div class="dashboard-body">
        <div class="dashboard-body__bar">
            <span class="dashboard-body__bar-icon"><i class="las la-bars"></i></span>
        </div>
        <div class="row gy-3 justify-content-center">
            <div class="col-lg-12">
                <div class="account-form">
                    <div class="row">
                        <div class="col-lg-12 text-end">
                            <button class="btn btn--base confirmationBtn"
                                data-question="@lang('Your current api key will removed. Are you sure to generate new api key?')"
                                data-action="{{ route('user.api.generateKey') }}">
                                @lang('Generate New Key')
                            </button>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label class="form-label fw-bold">@lang('API Key')</label>
                                <div class="input-group">
                                    <input type="text" value="{{ auth()->user()->api_key }}"
                                        class="form-control form--control referralURL" readonly>
                                    <button type="button" class="input-group-text copytext" id="copyBoard"> <i
                                            class="fa fa-copy"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="account-form">
                    <div class="row">
                        <h5>@lang('API Details')</h5>
                        <div class="col-sm-6 mb-3">
                            <p class="fw-bold">@lang('API URL')</p>
                            <span>{{ route('api.v1') }}</span>
                        </div>
                        <div class="col-sm-6 mb-3">
                            <p class="fw-bold">@lang('API Key')</p>
                            <span> {{ auth()->user()->api_key }} </span>
                        </div>
                        <div class="col-sm-6 mb-3">
                            <p class="fw-bold">@lang('HTTP Method')</p>
                            <p>@lang('post')</p>
                        </div>
                        <div class="col-sm-6 mb-3">
                            <p class="fw-bold">@lang('Response Format')</p>
                            <span>@lang('json')</span>
                        </div>
                        <div class="col-lg-6">
                            <p class="fw-bold mb-3">@lang('Example Code')</p>
                            <a class="btn btn--base btn--sm" href="{{ asset('assets/php_api_example.txt') }}" target="_blank">
                                <i class="las la-code"></i>
                                @lang('Example PHP Code')</a>
                        </div>
                    </div>
                </div>
            </div>



            <div class="col-lg-12">
                <div class="account-form">
                    <div class="row">
                        <h5>@lang('Place New Order')</h5>
                        <div class="col-sm-3 mb-3">
                            <p class="text-lowercase fw-bold">@lang('key')</p>
                            <span>@lang('Your API key')</span>
                        </div>
                        <div class="col-sm-3 mb-3">
                            <p class="text-lowercase fw-bold">@lang('action')</p>
                            <span> @lang('add')</span>
                        </div>
                        <div class="col-sm-3 mb-3">
                            <p class="text-lowercase fw-bold">@lang('service')</p>
                            <span>@lang('Service ID')</span>
                        </div>
                        <div class="col-sm-3 mb-3">
                            <p class="text-lowercase fw-bold">@lang('link')</p>
                            <span>@lang('Link to page')</span>
                        </div>

                        <div class="col-sm-3 mb-3">
                            <p class="text-lowercase fw-bold">@lang('quantity')</p>
                            <span>@lang('Needed quantity')</span>
                        </div>

                        <div class="col-sm-3 mb-3">
                            <p class="text-lowercase fw-bold">@lang('runs')
                                <small class="text-muted">@lang('(optional)')</small>
                            </p>
                            <span>@lang('Runs to deliver')</span>
                        </div>

                        <div class="col-sm-3 mb-3">
                            <p class="text-lowercase fw-bold">@lang('interval')
                                <small class="text-muted">@lang('(optional)')</small>
                            </p>
                            <span>@lang('Interval in minutes')</span>
                        </div>
                    </div>
                    <p class="fw-bold">@lang('Example Response')</p>
                    <div class="code-pre">
                        <pre>[
        {
            "status": "success",
            "order": 4488

        }
    ]</pre>
                    </div>
                </div>
            </div>


            <div class="col-lg-12">
                <div class="account-form">
                    <div class="row">
                        <h5>@lang('Order Status')</h5>
                        <div class="col-sm-4 mb-3">
                            <p class="text-lowercase fw-bold">@lang('key')</p>
                            <span>@lang('Your API key')</span>
                        </div>
                        <div class="col-sm-4 mb-3">
                            <p class="text-lowercase fw-bold">@lang('action')</p>
                            <span> @lang('status')</span>
                        </div>
                        <div class="col-sm-4 mb-3">
                            <p class="text-lowercase fw-bold">@lang('order')</p>
                            <span>@lang('Order ID')</span>
                        </div>
                    </div>
                    <p class="fw-bold">@lang('Available Staus:')</p>
                    <div class="d-flex mb-2">
                        <span class="badge--danger">@lang('pending')</span>
                        <span class="badge--warning">@lang('processing')</span>
                        <span class="badge--success">@lang('completed')</span>
                        <span class="badge--info">@lang('cancelled')</span>
                        <span class="badge--danger">@lang('refunded')</span>
                    </div>
                    <p class="fw-bold">@lang('Success Response')</p>
                    <div class="code-pre">
                        <pre>[
        {
            "status" : "pending",
            "start_count" : "1000",
            "remains" : "500",
            "currency" : USD

        }
    ]</pre>
                    </div>
                </div>
            </div>


            <div class="col-lg-12">
                <div class="account-form">
                    <div class="row">
                        <h5>@lang('Service Lists')</h5>
                        <div class="col-sm-4 mb-3">
                            <p class="text-lowercase fw-bold">@lang('key')</p>
                            <span>@lang('Your API key')</span>
                        </div>
                        <div class="col-sm-4 mb-3">
                            <p class="text-lowercase fw-bold">@lang('action')</p>
                            <span> @lang('services')</span>
                        </div>
                    </div>
                    <p class="fw-bold">@lang('Success Response')</p>
                    <div class="code-pre">
                        <pre>[
        {
                "service": 1,
                "name": "🙋‍♂️ Followers [Ultra-High Quality Profiles]",
                "category": "🥇 [VIP]\r\n",
                "rate": "4.80",
                "min": 100,
                "max": 10000
            },
            {
                "service": 11,
                "name": "🧨 Instagram Power Comments (100k+ Accounts) ➡️ [3 Comments]",
                "category": "💬 Instagram - Verified / Power Comments [ Own Service ]",
                "rate": "0.60",
                "min": 500,
                "max": 5000
            },
            {
                "service": 52,
                "name": "🎙️ Facebook Live Stream Views ➡️ [ 120 Min ]",
                "category": "🔵 Facebook - Live Stream Views\r\n",
                "rate": "57.60",
                "min": 50,
                "max": 2000
            }
    ]</pre>
                    </div>
                </div>
            </div>


            <div class="col-lg-12">
                <div class="account-form">
                    <div class="row">
                        <h5>@lang('User Balance')</h5>
                        <div class="col-sm-4 mb-3">
                            <p class="text-lowercase fw-bold">@lang('key')</p>
                            <span>@lang('Your API key')</span>
                        </div>
                        <div class="col-sm-4 mb-3">
                            <p class="text-lowercase fw-bold">@lang('action')</p>
                            <span> @lang('balance')</span>
                        </div>
                    </div>
                    <p class="fw-bold">@lang('Success Response')</p>
                    <div class="code-pre">
                        <pre>[
        {
            "status": "success",
            "balance": "0.03",
            "currency": "USD"
        }
    ]</pre>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<x-confirmation-modal />

@endsection

@push('script')
<script>
    (function($) {
            "use strict";
            $('#copyBoard').on('click', function() {
                var copyText = document.getElementsByClassName("referralURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                document.execCommand("copy");
                copyText.blur();
                this.classList.add('copied');
                setTimeout(() => this.classList.remove('copied'), 1500);
            });
        })(jQuery);
</script>
@endpush
