@php
  $faq = getContent('faq.content',true);
  $faqElements = getContent('faq.element',false,12);
@endphp

<!-- ==================== FAQ Start ==================== -->
<section class="faq py-80">
    <div class="container">
        <div class="title">
            <h4>{{__(@$faq->data_values->heading)}}</h4>
            <p>{{__(@$faq->data_values->sub_heading)}}</p>
        </div>
        <div class="row gy-4 justify-content-center">
            <div class="col-lg-6">
                <div class="accordion custom--accordion" id="accordionExample1">
                    @foreach($faqElements as $index => $item)
                        @if($index % 2 == 0)
                            <div class="accordion-item">
                                <h2 class="accordion-header d-flex align-items-center" id="heading{{ $index }}One">
                                    <span class="number">{{ $index + 1 }}</span>
                                    <button class="accordion-button {{ $index == 0 ? '' : 'collapsed' }}" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{ $index }}One" aria-expanded="{{ $index == 0 ? 'true' : 'false' }}">
                                        {{__(@$item->data_values->question) }}
                                    </button>
                                </h2>
                                <div id="collapse{{ $index }}One" class="accordion-collapse collapse {{ $index == 0 ? 'show' : '' }}" aria-labelledby="heading{{ $index }}One" data-bs-parent="#accordionExample1">
                                    <div class="accordion-body">
                                        @php echo $item->data_values->answer; @endphp
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
            <div class="col-lg-6">
                <div class="accordion custom--accordion" id="accordionExample2">
                    @foreach($faqElements as $index => $item)
                        @if($index % 2 != 0)
                            <div class="accordion-item">
                                <h2 class="accordion-header d-flex align-items-center" id="heading{{ $index }}Two">
                                    <span class="number">{{ $index + 1 }}</span>
                                    <button class="accordion-button {{ $index == 1 ? '' : 'collapsed' }}" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{ $index }}Two" aria-expanded="{{ $index == 1 ? 'true' : 'false' }}">
                                        {{__(@$item->data_values->question) }}
                                    </button>
                                </h2>
                                <div id="collapse{{ $index }}Two" class="accordion-collapse collapse {{ $index == 1 ? 'show' : '' }}" aria-labelledby="heading{{ $index }}Two" data-bs-parent="#accordionExample2">
                                    <div class="accordion-body">
                                        @php echo $item->data_values->answer; @endphp
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ==================== FAQ End ==================== -->
