@extends($activeTemplate.'layouts.master')
@section('content')
<div class="body-wrapper">
    <div class="table-content">
        <div class="body-area">
            <form action="{{route('user.brand.package.place')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="row gy-3">
                    <div class="col-sm-12">
                        <div class="form-group">
                            <label for="name" class="form--label"> @lang('Brand Package')</label>
                            <input type="text" class="form--control" id="name" name="name" value="{{$brandPackage->name}}" readonly>
                        </div>
                    </div>
                    @php
                    $brandPackageLink = json_decode($brandPackage->link_field, true);
                    @endphp
                    @if(!empty($brandPackageLink) && is_array($brandPackageLink))
                    @foreach($brandPackageLink as $key => $value)
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="link" class="form--label">{{__($value)}}</label>
                            <input type="text" class="form--control" id="link" name="links[]"
                                placeholder="@lang('Your Link')">
                        </div>
                    </div>
                    @endforeach
                    @endif

                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="price" class="form--label">@lang('Price')</label>
                            <input type="text" class="form--control price" id="price" name="price" value="{{$brandPackage->price}}" readonly>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="form-group">
                            <label class="form--label" for="mass_order">@lang('Note')</label>
                            <textarea name="note" class="form--control" id="" cols="30" rows="10"></textarea>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="agree" name="check">
                            <label class="form-check-label" for="agree">@lang('Yes, i have confirmed the order!')</label>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="card-body">
                            <p class="fw-bold">@lang('Brand Package Details')</p>
                            <div class="selling-group-item">
                                <small class="text-muted">@lang('Name')</small>
                                <span>{{__($brandPackage->name)}}</span>
                            </div>

                            <div class="selling-group-item">
                                <small class="text-muted">@lang('Price')</small>
                                <span>{{$general->cur_sym}} {{__($brandPackage->price)}}</span>
                            </div>

                            <div class="selling-group-item">
                                <small class="text-muted">@lang('Details')</small>
                                @if(@$brandPackage->content)
                                @foreach(json_decode(@$brandPackage->content) as $value)
                                <span> <i class="fas fa-check"></i> {{__($value)}}</span>
                                @endforeach
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-12 text-end">
                        <button type="submit" class="btn btn--base">
                            @lang('Place Order') <i class="fas fa-arrow-right"></i>
                        </button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection
