
<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="table-content">
        <div class="m-0">
            <div class="list-card">
                <div class="row search-dash justify-content-end mb-3">
                    <div class="col-12">
                        <form action="">
                            <div class="d-flex flex-wrap gap-4">
                                <div class="flex-grow-1">
                                    <label class="form--label"><?php echo app('translator')->get('Transaction Number'); ?></label>
                                    <input type="text" name="search" value="<?php echo e(request()->search); ?>" class="form--control">
                                </div>
                                <div class="flex-grow-1">
                                    <label class="form--label"><?php echo app('translator')->get('Type'); ?></label>
                                    <select name="type" class="form--control form-select">
                                        <option value=""><?php echo app('translator')->get('All'); ?></option>
                                        <option value="+" <?php if(request()->type == '+'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Plus'); ?></option>
                                        <option value="-" <?php if(request()->type == '-'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Minus'); ?></option>
                                    </select>
                                </div>
                                <div class="flex-grow-1">
                                    <label class="form--label"><?php echo app('translator')->get('Remark'); ?></label>
                                    <select class="form--control form-select" name="remark">
                                        <option value=""><?php echo app('translator')->get('Any'); ?></option>
                                        <?php $__currentLoopData = $remarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $remark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($remark->remark); ?>" <?php if(request()->remark ==
                                            $remark->remark): echo 'selected'; endif; ?>><?php echo e(__(keyToTitle($remark->remark))); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="flex-grow-1 align-self-end">
                                    <button class="btn btn--base w-100"><?php echo app('translator')->get('Filter'); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <table class="custom-table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Trx'); ?></th>
                                    <th><?php echo app('translator')->get('Transacted'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                    <th><?php echo app('translator')->get('Post Balance'); ?></th>
                                    <th><?php echo app('translator')->get('Detail'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td data-label="<?php echo app('translator')->get('Trx'); ?>">
                                       <?php echo e($trx->trx); ?>

                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Transacted'); ?>">
                                        <?php echo e(showDateTime($trx->created_at)); ?>

                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                                        <span
                                            class="<?php if($trx->trx_type == '+'): ?>text-success <?php else: ?> text-danger <?php endif; ?>">
                                            <?php echo e($trx->trx_type); ?> <?php echo e(showAmount($trx->amount)); ?> <?php echo e($general->cur_text); ?>

                                        </span>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Post Balance'); ?>">
                                        <?php echo e(showAmount($trx->post_balance)); ?> <?php echo e(__($general->cur_text)); ?>

                                    </td>


                                    <td data-label="<?php echo app('translator')->get('Detail'); ?>"><?php echo e(__($trx->details)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%" data-label="<?php echo app('translator')->get('Transaction Table'); ?>"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-5">
                        <?php if($transactions->hasPages()): ?>
                        <div class="text-end">
                            <?php echo e($transactions->links()); ?>

                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/presets/themeTwo/user/transactions.blade.php ENDPATH**/ ?>