
<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="table-content">
        <div class="row gy-4 mb-4">
            <div class="col-xl-3 col-lg-4 col-md-4 col-12">
                <div class="dash-card">
                    <a href="javascript:void(0)" class="d-flex justify-content-between">
                        <div>
                            <div>
                                <p><?php echo app('translator')->get('Balance'); ?></p>
                            </div>
                            <div class="content">
                                <span class="text-uppercase"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($user->balance)); ?></span>
                            </div>

                        </div>
                        <div class="icon my-auto">
                            <i class="fas fa-dollar-sign"></i>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-4 col-12">
                <div class="dash-card">
                    <a href="<?php echo e(route('user.order.index')); ?>" class="d-flex justify-content-between">
                        <div>
                            <div>
                                <p><?php echo app('translator')->get('Total Orders'); ?></p>
                            </div>
                            <div class="content">
                                <span class="text-uppercase"><?php echo e($orderCount); ?></span>
                            </div>

                        </div>
                        <div class="icon my-auto">
                            <i class="fas fa-cart-plus"></i>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-4 col-12">
                <div class="dash-card">
                    <a href="<?php echo e(route('user.brnad.package.index')); ?>" class="d-flex justify-content-between">
                        <div>
                            <div>
                                <p><?php echo app('translator')->get('Branding Orders'); ?></p>
                            </div>
                            <div class="content">
                                <span class="text-uppercase"><?php echo e($brandOrderCount); ?></span>
                            </div>

                        </div>
                        <div class="icon my-auto">
                            <i class="fas fa-cart-plus"></i>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-4 col-12">
                <div class="dash-card">
                    <a href="<?php echo e(route('user.transactions')); ?>" class="d-flex justify-content-between">
                        <div>
                            <div>
                                <p><?php echo app('translator')->get('Transactions'); ?></p>
                            </div>
                            <div class="content">
                                <span class="text-uppercase"><?php echo e($transectionCount); ?></span>
                            </div>

                        </div>
                        <div class="icon my-auto">
                            <i class="fas fa-funnel-dollar"></i>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-12">
                <div class="chart">
                    <div class="chart-bg">
                        <h5><?php echo app('translator')->get('Monthly Deposit History'); ?></h5>
                        <div id="account-chart"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="m-0">
            <div class="list-card">
                <div class="header-title-list">
                    <h4 class="pb-0"><?php echo app('translator')->get('Recent Orders'); ?></h4>
                </div>
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <table class="custom-table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Order No'); ?></th>
                                    <th><?php echo app('translator')->get('Service Name'); ?></th>
                                    <th><?php echo app('translator')->get('Link'); ?></th>
                                    <th><?php echo app('translator')->get('Price'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="text-center">
                                    <td data-label="<?php echo app('translator')->get('Order No'); ?>">#<?php echo e($item->order_no); ?></td>
                                    <td data-label="<?php echo app('translator')->get('Service Name'); ?>">
                                        <?php if(strlen(__(@$item->service->name)) >30): ?>
                                        <?php echo e(substr( __(@$item->service->name), 0,30).'...'); ?>

                                        <?php else: ?>
                                        <?php echo e(__(@$item->service->name)); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td data-label="<?php echo app('translator')->get('Link'); ?>">
                                        <a href="<?php echo e($item->link); ?>" target="_blank" class="text--base"><?php echo e($item->link); ?></a>
                                    </td>
                                    <td data-label="<?php echo app('translator')->get('Price'); ?>"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($item->price)); ?>

                                    </td>
                                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                        <?php
                                        echo $item->statusBadge($item->status);
                                        ?>
                                    </td>
                                    <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                        <button class="btn btn--base btn--sm detailsModalBtn" data-start_count="<?php echo e($item->start_count); ?>" data-remains="<?php echo e($item->remains); ?>" data-name="<?php echo e(@$item->service->name); ?>"><i class="fas fa-eye"></i></button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%" data-label="<?php echo app('translator')->get('Order Table'); ?>">
                                        <?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

    </div>
</div>


<div id="detailsModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Order Details'); ?></h5>
                <button type="button" class="close btn btn--sm btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="modal-body">
                    <p><strong><?php echo app('translator')->get('Service Name'); ?>:</strong> <span class="serviceName"></span></p>
                    <p><strong><?php echo app('translator')->get('Start Counter'); ?>:</strong> <span class="start_count"></span></p>
                    <p><strong><?php echo app('translator')->get('Remains'); ?>:</strong> <span class="remains"></span></p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="<?php echo e(asset('assets/admin/js/apexcharts.min.js')); ?>"></script>
<script>
    (function () {
        "use strict";

        $('.detailsModalBtn').on('click', function () {
            var modal = $('#detailsModal');
            modal.find('.serviceName').text($(this).data('name'));
            modal.find('.start_count').text($(this).data('start_count'));
            modal.find('.remains').text($(this).data('remains'));
            modal.modal('show');
       });

        var options = {
            chart: {
                type: 'area',
                stacked: false,
                height: '310px'
            },
            stroke: {
                width: [0, 3],
                curve: 'smooth'
            },
            plotOptions: {
                bar: {
                    columnWidth: '50%'
                }
            },
            colors: ['#00adad', '#67BAA7'],
            series: [{
        name: '<?php echo app('translator')->get("Deposits"); ?>',
        type: 'area',
        data: <?php echo json_encode($depositsChart['values'], 15, 512) ?>
    }],
    fill: {
        opacity: [0.85, 1],
                },
    labels: <?php echo json_encode($depositsChart['labels'], 15, 512) ?>,
    markers: {
        size: 0
    },
    xaxis: {
        type: 'text'
    },
    yaxis: {
        min: 0
    },
    tooltip: {
        shared: true,
            intersect: false,
                y: {
            formatter: function (y) {
                if (typeof y !== "undefined") {
                    return "$ " + y.toFixed(0);
                }
                return y;

            }
        }
    },
    legend: {
        labels: {
            useSeriesColors: true
        },
        markers: {
            customHTML: [
                function () {
                    return ''
                },
                function () {
                    return ''
                }
            ]
        }
    }
            }
    var chart = new ApexCharts(
        document.querySelector("#account-chart"),
        options
    );
    chart.render();
    }) ();
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/presets/themeTwo/user/dashboard.blade.php ENDPATH**/ ?>