
<?php $__env->startSection('panel'); ?>

<div class="row mb-3">
    <div class="col-lg-12 text-end">
        <a href="<?php echo e(route('admin.category.create')); ?>" class="btn btn-sm btn--primary"><?php echo app('translator')->get('Add Category'); ?></a>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">

        
        <div class="show-filter mb-3 text-end">
        <button type="button" class="btn btn--primary showFilterBtn btn-sm"><i class="las la-filter"></i> <?php echo app('translator')->get('Filter'); ?></button>
        </div>

        <div class="card responsive-filter-card mb-4">
            <div class="card-body">
                <form action="<?php echo e(route('admin.category.filter')); ?>" method="get">
                    <div class="d-flex flex-wrap gap-4">
                        <div class="flex-grow-1">
                            <label><?php echo app('translator')->get('Name'); ?></label>
                            <input type="text" name="name" class="form-control"
                                placeholder="<?php echo app('translator')->get('Type Here'); ?>">
                        </div>
                        <div class="flex-grow-1">
                            <label><?php echo app('translator')->get('Status'); ?></label>
                            <select name="status" class="form-control">
                                <option value=""><?php echo app('translator')->get('Select Status'); ?></option>
                                <option value="1"><?php echo app('translator')->get('Active'); ?></option>
                                <option value="0"><?php echo app('translator')->get('Inactive'); ?></option>
                            </select>
                        </div>
                        <div class="flex-grow-1 align-self-end">
                            <button type="submit" class="btn btn--primary h-40 w-100"><i class="fas fa-check"></i><?php echo app('translator')->get('Apply'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        

        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('S/N'); ?></th>
                                <th><?php echo app('translator')->get('Name'); ?></th>
                                <th><?php echo app('translator')->get('Icon'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($key+1); ?></td>
                                <td><?php echo e(__($item->name)); ?></td>
                                <td> <img src="<?php echo e(getImage(getFilePath('category').'/'.@$item->logo)); ?>" class="rounded" alt="<?php echo app('translator')->get('image'); ?>" style="width:32px"> </td>

                                <td> <?php echo $item->statusBadge($item->status); ?> </td>

                                <td>
                                    <a href="<?php echo e(route('admin.category.edit',$item->id)); ?>" title="<?php echo app('translator')->get('Edit'); ?>" data-id="<?php echo e($item->id); ?>" class="btn btn-sm btn--primary ">
                                        <i class="las la-edit"></i>
                                    </a>
                                    <button title="<?php echo app('translator')->get('Status Change'); ?>"
                                     data-id="<?php echo e($item->id); ?>" data-status ="<?php echo e($item->status); ?>"
                                        class="btn btn-sm btn--danger statusChangeBtn">
                                        <i class="fas fa-sync-alt"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                            <?php endif; ?>

                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            <?php if($categories->hasPages()): ?>
            <div class="card-footer py-4">
                <?php echo e(paginateLinks($categories)); ?>

            </div>
            <?php endif; ?>
        </div><!-- card end -->
    </div>
</div>


<div id="statusChangeModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Status Change Confirmation!'); ?></h5>
                <button type="button" class="close btn btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="<?php echo e(route('admin.category.status.change')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <input type="hidden" name="id">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for=""><?php echo app('translator')->get('Status'); ?></label>
                            <select id="status" name="status" class="form-control">
                                <option <?php if(1): ?> selected <?php endif; ?> value="1"><?php echo app('translator')->get('Active'); ?></option>
                                <option <?php if(0): ?> selected <?php endif; ?> value="0"><?php echo app('translator')->get('Inactive'); ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Confirm'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
<script>
    $('.statusChangeBtn').on('click', function () {
        var modal = $('#statusChangeModal');
        modal.find('input[name=id]').val($(this).data('id'));
        var status = $(this).data('status');
        modal.find('select[name=status]').val(status);
        modal.modal('show');
    });
</script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/admin/categories/index.blade.php ENDPATH**/ ?>