@extends('admin.layouts.app')
@section('panel')

<div class="row mb-none-30">
    <div class="col-lg-12 mb-30">
        <div class="card">
            <div class="card-body">
                <form action="{{route('admin.order.update',$order->id)}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row gy-2">
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="name"> @lang('Status'):</label>
                                @php
                                    echo $order->statusBadge($order->status);
                                @endphp
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold">@lang('Category')</label>
                                <input type="text" class="form-control" value="{{@$order->category->name}}" readonly>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold">@lang('Service')</label>
                                <input type="text" class="form-control" value="{{@$order->service->name}}" readonly>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold">@lang('Link')</label>
                                <input type="text" class="form-control" value="{{$order->link}}"  readonly>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold">@lang('Quantity')</label>
                                <input type="text" class="form-control" value="{{$order->quantity}}" readonly>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold">@lang('Interval')</label>
                                <input type="text" class="form-control" value="{{$order->interval}}"
                                    placeholder="@lang('Interval')" readonly>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold">@lang('Runs')</label>
                                <input type="text" class="form-control" value="{{$order->runs}}"
                                    placeholder="@lang('Runs')" readonly>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold">@lang('Remains')</label>
                                <input type="text" class="form-control" value="{{$order->remains}}"
                                    placeholder="@lang('Remains')" readonly>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold">@lang('Start Counter')</label>
                                <input type="text" class="form-control" value="{{$order->start_count}}"
                                    placeholder="@lang('Start Counter')" readonly>
                            </div>
                        </div>


                        @if(@$order->status == 0 || @$order->status == 1)
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold">@lang('Start Counter')</label>
                                <input type="text" class="form-control" name="start_count"
                                    placeholder="@lang('Start Counter')">
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="name"> @lang('Status'):</label>
                                <select name="status" class="form-control">
                                    <option value="0" {{ @$order->status == 0 ? 'selected' : '' }}>@lang('Pending')
                                    </option>
                                    <option value="1" {{ @$order->status == 1 ? 'selected' : '' }}>@lang('Processing')
                                    </option>
                                    <option value="2" {{ @$order->status == 2 ? 'selected' : '' }}>@lang('Completed')
                                    </option>
                                    <option value="3" {{ @$order->status == 3 ? 'selected' : '' }}>@lang('Cancelled')
                                    </option>
                                    <option value="4" {{ @$order->status == 4 ? 'selected' : '' }}>@lang('Refunded')
                                    </option>
                                </select>
                            </div>
                        </div>
                        @elseif(@$order->status == 3 || @$order->status == 4)
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold">@lang('Reason')</label>
                                <textarea cols="30" rows="10" readonly>{{__(@$order->reason??'N/A')}}</textarea>
                            </div>
                        </div>
                        @endif

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold">@lang('User Note')</label>
                               <textarea cols="30" rows="10"  readonly>{{$order->note??'N/A'}}</textarea>
                            </div>
                        </div>

                        <div id="reason-field" class="col-lg-12" style="display: none;">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold">@lang('Reason')</label>
                                <textarea name="reason" id="reason" cols="30" rows="10"></textarea>
                            </div>
                        </div>

                        @if(@$order->status == 0 || @$order->status == 1)
                        <div class="col-lg-12 ">
                            <div class="form-group float-end">
                                <button type="submit" class="btn btn--primary btn-block btn-lg">
                                    @lang('Update')</button>
                            </div>
                        </div>
                        @endif
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script>
    $(document).ready(function () {
        "use strict";
        $('#status').on('change',function () {
            var selectedStatus = $(this).val();
            if (selectedStatus == '3' || selectedStatus == '4') {
                $('#reason-field').show();
            } else {
                $('#reason-field').hide();
            }
        });
    });
</script>
@endpush
