@extends($activeTemplate.'layouts.master')
@section('content')
<div class="col-xl-9 col-lg-12">
    <div class="dashboard-body">
        <div class="order-wrap">
            <div class="account-form">
                <div class="dashboard-body__bar">
                    <span class="dashboard-body__bar-icon"><i class="las la-bars"></i></span>
                </div>
                <form action="{{route('user.service.order.place')}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row gy-3">
                        <div class="col-lg-6">
                            <div class="row gy-3">

                                <div class="account-form__content">
                                    <h3 class="account-form__title mb-2">{{$pageTitle}} </h3>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form--label">@lang('Category')</label>
                                        <select class="select form--control category" name="category">
                                            <option selected>@lang('Select Category')</option>
                                            @foreach ($categories as $item)
                                            <option value="{{$item->id}}">{{$item->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form--label">@lang('Service')</label>
                                        <select class="select form--control services" name="service">
                                            <option selected>@lang('Select Service')</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label for="link" class="form--label"> @lang('Your Link')</label>
                                        <input type="text" class="form--control" id="link" name="link"
                                            placeholder="@lang('Your Link')">
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label for="quantity" class="form--label">@lang('Quantity')</label>
                                        <input type="number" class="form--control quantity" id="quantity" min="1"
                                            name="quantity" placeholder="@lang('Quantity')">
                                    </div>
                                </div>

                                <div class="form-group drip_feed d-none col-lg-12">
                                    <label class="form--label">@lang('Drip feed')</label>
                                    <input type="checkbox" name="drip_feed" class="custom-switch-checkbox dripfeed" id="status" value="1">
                                </div>

                                <div class="drip_feed_check d-none col-lg-12">
                                    <div class="row gy-3">
                                        <div class="col-sm-6">
                                            <div class="form-group drip_feed">
                                                <label class="form--label">@lang('Runs')</label>
                                                <input type="number" id="runs" name="runs" class="form--control runs" value="{{ old('runs') }}">

                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group drip_feed">
                                                <label class="form--label">@lang('Interval (in minutes)')</label>
                                                <input type="number" name="interval" class="form--control interval" value="{{ old('interval') }}">
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="form-group drip_feed">
                                                <label class="form--label">@lang('Total Quantity')</label>
                                                <input type="text" class="form--control total_quantity" disabled>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label for="quantity" class="form--label">@lang('Price')</label>
                                        <input step="any" type="number" class="form--control price"  placeholder="@lang('Price')">
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="row gy-3 service-details">
                                <div class="account-form__content">
                                    <h3 class="account-form__title mb-2">@lang('Service Details') </h3>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form--label">@lang('Service name')</label>
                                        <input type="text" class="form--control d_service_name" placeholder="@lang('Service Name')" disabled>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form--label">@lang('Minimum')</label>
                                        <input class="form--control d_service_min" placeholder="@lang('min')" disabled>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form--label">@lang('Maximum')</label>
                                        <input class="form--control d_service_max" placeholder="@lang('max')" disabled>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form--label">@lang('Price per 1k')</label>
                                        <input class="form--control d_service_price" placeholder="@lang('0.00')" disabled>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label class="form--label">@lang('Description')</label>
                                        <textarea class="form--control d_service_description" placeholder="@lang('Description')" disabled rows="12"></textarea>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label class="form--label" for="mass_order">@lang('Note')</label>
                              <textarea name="note" class="form--control" id="" cols="30" rows="10"></textarea>
                            </div>
                        </div>


                        <div class="col-lg-12">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="agree" name="check">
                                <label class="form-check-label" for="agree">@lang('Yes, i have confirmed the order!')</label>
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <button type="submit" class="btn btn--base w-100">
                                @lang('Place Order') <i class="fas fa-arrow-right"></i>
                                <span style="top: 16px; left: 578px;"></span>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection



@push('script')
<script>
    $(document).ready(function () {
        "use strict";

        $(document).on('change', '.category', function (e) {
            var categoryId = $('option:selected', this).val();
            getService(categoryId);
        });

        $(document).on('change', '.services', function () {
            var serviceId = $('option:selected', this).val();
            getServiceDetails(serviceId)
        });

        var total = 1;
        $(document).on('change keyup', '.quantity,.runs', function () {
            var quan = $('.quantity').val();
            var run = $('.runs').val();
            var total = quan * run;
            $('.total_quantity').val(total);

        });

        $(document).on('change keyup', '.quantity', function () {
            var quan = $('.quantity').val();
            var pri = $('.d_service_price').val();
            var total = ((quan * pri) / 1000).toFixed(2);
            $('.price').val(total);
        });

        $(document).on('change', '.dripfeed', function () {
            var isChecked = $(this).is(":checked");
            var elementToShowHide = $('.drip_feed_check');

            if (isChecked) {
                elementToShowHide.removeClass('d-none');
                $(this).val(1);
            } else {
                elementToShowHide.addClass('d-none');
                $(this).val(0);
            }
        });

        function getService(categoryId) {

            $.ajax({
                url: "{{ route('user.get.ajax.services') }}",
                type: "get",
                data: {categoryId: categoryId},
                success: function (data) {
                    $('.services').html('');

                    if (data.length) {

                        $(data).each(function (key, val) {

                        $('.services').append('<option value="' + val.id + '">' + val.name + '</option>');

                        });

                        let serviceId = !data[0].id ? serviceId : data[0].id;
                        getServiceDetails(serviceId);

                    }else{

                        $('.service-details').find('input').val('');
                    }
                }
            })
        }

        function getServiceDetails(serviceId) {

            $.ajax({
                type: "get",
                data: {serviceId: serviceId},
                url: "{{ route('user.get.ajax.service.details') }}",
                success: function (data) {

                    var price = parseFloat(data.price).toFixed(4);

                    $('.d_service_name').val(data.name);
                    $('.d_service_min').val(data.min);
                    $('.d_service_max').val(data.max);
                    $('.d_service_price').val(price);
                    $('.d_service_description').val(data.description);
                    if (data.drip_feed == 1) {
                        $('.drip_feed').removeClass('d-none');
                        $('.dripfeed').prop('checked', true).trigger('change');
                    } else {
                        $('.drip_feed').addClass('d-none');
                        $('.dripfeed').prop('checked', false).trigger('change');
                    }
                }
            });
        }

    });
</script>
@endpush
