@extends($activeTemplate.'layouts.frontend')
@section('content')
@php
    $banner = getContent('theme_two_banner.content', true);
    $highlightedText = $banner->data_values->highlighted_heading_text;
@endphp
<!--========================== Banner Section Start ==========================-->
<section class="banner-section">
    <div class="banner-thumb">
        <div class="shape1 d-none d-lg-block">
            <img src="{{ asset($activeTemplateTrue .'images/shape/shape1.png') }}" alt="@lang('shape')">
        </div>
        <div class="shape2">
            <img src="{{ asset($activeTemplateTrue .'images/shape/shape2.png') }}" alt="@lang('shape')">
        </div>
        <div class="shape3 d-none d-lg-block">
            <img src="{{ asset($activeTemplateTrue .'images/shape/shape3.png') }}" alt="@lang('shape')">
        </div>
        <div class="container">
            <div class="row">
                <div class="col-12 my-auto">
                    <div class="content">
                        <h5>{{__(@$banner->data_values->top_heading)}}</h5>
                        <h3>
                            {!! str_replace(__(@$highlightedText),"<span class='text--base'>$highlightedText</span>",__(@$banner->data_values->heading) )!!}
                        </h3>
                        <p>
                            @if(strlen(__(@$banner->data_values->sub_heading)) >125)
                            {{substr(__(@$banner->data_values->sub_heading), 0,125).'...' }}
                            @else
                            {{__(@$banner->data_values->sub_heading)}}
                            @endif
                        </p>
                        <div class="action">
                            <a href="{{route('user.login')}}" class="btn btn--base mx-3">@lang('Get Started')</a>
                            <a href="{{route('services')}}" class="btn btn--base d-md-block d-none">@lang('Our Service')</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--========================== Banner Section End ==========================-->

@if($sections->secs != null)
@foreach(json_decode($sections->secs) as $sec)
@include($activeTemplate.'sections.'.$sec)
@endforeach
@endif
@endsection

