@php
    $wheretoBegin = getContent('where_to_begin.content',true);
    $wheretoBeginElements = getContent('where_to_begin.element',false);
@endphp
<!-- ====================  Works Start ==================== -->
<section class="works py-80">
    <div class="container">
        <div class="title">
            <h4>{{__(@$wheretoBegin->data_values->top_heading)}}</h4>
            <p>{{__(@$wheretoBegin->data_values->heading)}}</p>
        </div>
        <div class="row gy-4 mt-2">
            @forelse($wheretoBeginElements as $item)
            <div class="col-xl-3 col-lg-4 col-md-6 col-12">
                <div class="card">
                    <div class="d-flex">
                        <div>
                            @php echo $item->data_values->service_icon; @endphp
                        </div>
                        <div class="hr"></div>
                    </div>
                    <div class="content">
                        <h5> @if(strlen(strip_tags(__(@$item->data_values->title))) >50)
                            {{substr(strip_tags(__(@$item->data_values->title)), 0,50).'...' }}
                            @else
                            {{strip_tags(__(@$item->data_values->title))}}
                            @endif
                        </h5>
                        <p>
                            @if(strlen(__(@$item->data_values->description)) >80)
                            {{substr(__(@$item->data_values->description), 0,80).'...' }}
                            @else
                            {{__(@$item->data_values->description)}}
                            @endif
                        </p>
                    </div>
                </div>
            </div>
            @empty
            <h2 class="text-center">{{__($emptyMessage)}}</h2>
            @endforelse
        </div>
    </div>
</section>
<!-- ====================  Works End ==================== -->
