@extends($activeTemplate.'layouts.master')
@section('content')
<div class="body-wrapper">
    <div class="table-content">
        <div class="row gy-4 mb-4">
            <div class="col-xl-3 col-lg-4 col-md-4 col-12">
                <div class="dash-card">
                    <a href="javascript:void(0)" class="d-flex justify-content-between">
                        <div>
                            <div>
                                <p>@lang('Balance')</p>
                            </div>
                            <div class="content">
                                <span class="text-uppercase">{{$general->cur_sym}}{{ showAmount($user->balance)}}</span>
                            </div>

                        </div>
                        <div class="icon my-auto">
                            <i class="fas fa-dollar-sign"></i>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-4 col-12">
                <div class="dash-card">
                    <a href="{{route('user.order.index')}}" class="d-flex justify-content-between">
                        <div>
                            <div>
                                <p>@lang('Total Orders')</p>
                            </div>
                            <div class="content">
                                <span class="text-uppercase">{{$orderCount}}</span>
                            </div>

                        </div>
                        <div class="icon my-auto">
                            <i class="fas fa-cart-plus"></i>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-4 col-12">
                <div class="dash-card">
                    <a href="{{route('user.brnad.package.index')}}" class="d-flex justify-content-between">
                        <div>
                            <div>
                                <p>@lang('Branding Orders')</p>
                            </div>
                            <div class="content">
                                <span class="text-uppercase">{{$brandOrderCount}}</span>
                            </div>

                        </div>
                        <div class="icon my-auto">
                            <i class="fas fa-cart-plus"></i>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-4 col-12">
                <div class="dash-card">
                    <a href="{{route('user.transactions')}}" class="d-flex justify-content-between">
                        <div>
                            <div>
                                <p>@lang('Transactions')</p>
                            </div>
                            <div class="content">
                                <span class="text-uppercase">{{$transectionCount}}</span>
                            </div>

                        </div>
                        <div class="icon my-auto">
                            <i class="fas fa-funnel-dollar"></i>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-12">
                <div class="chart">
                    <div class="chart-bg">
                        <h5>@lang('Monthly Deposit History')</h5>
                        <div id="account-chart"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="m-0">
            <div class="list-card">
                <div class="header-title-list">
                    <h4 class="pb-0">@lang('Recent Orders')</h4>
                </div>
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <table class="custom-table">
                            <thead>
                                <tr>
                                    <th>@lang('Order No')</th>
                                    <th>@lang('Service Name')</th>
                                    <th>@lang('Link')</th>
                                    <th>@lang('Price')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($orders as $item)
                                <tr class="text-center">
                                    <td data-label="@lang('Order No')">#{{$item->order_no}}</td>
                                    <td data-label="@lang('Service Name')">
                                        @if(strlen(__(@$item->service->name)) >30)
                                        {{substr( __(@$item->service->name), 0,30).'...' }}
                                        @else
                                        {{__(@$item->service->name)}}
                                        @endif
                                    </td>
                                    <td data-label="@lang('Link')">
                                        <a href="{{$item->link}}" target="_blank" class="text--base">{{$item->link}}</a>
                                    </td>
                                    <td data-label="@lang('Price')">{{$general->cur_sym}}{{ showAmount($item->price) }}
                                    </td>
                                    <td data-label="@lang('Status')">
                                        @php
                                        echo $item->statusBadge($item->status);
                                        @endphp
                                    </td>
                                    <td data-label="@lang('Action')">
                                        <button class="btn btn--base btn--sm detailsModalBtn" data-start_count="{{$item->start_count}}" data-remains="{{$item->remains}}" data-name="{{@$item->service->name}}"><i class="fas fa-eye"></i></button>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%" data-label="@lang('Order Table')">
                                        {{__($emptyMessage) }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

    </div>
</div>

{{-- details modal --}}
<div id="detailsModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Order Details')</h5>
                <button type="button" class="close btn btn--sm btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="modal-body">
                    <p><strong>@lang('Service Name'):</strong> <span class="serviceName"></span></p>
                    <p><strong>@lang('Start Counter'):</strong> <span class="start_count"></span></p>
                    <p><strong>@lang('Remains'):</strong> <span class="remains"></span></p>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('script')
<script src="{{asset('assets/admin/js/apexcharts.min.js')}}"></script>
<script>
    (function () {
        "use strict";

        $('.detailsModalBtn').on('click', function () {
            var modal = $('#detailsModal');
            modal.find('.serviceName').text($(this).data('name'));
            modal.find('.start_count').text($(this).data('start_count'));
            modal.find('.remains').text($(this).data('remains'));
            modal.modal('show');
       });

        var options = {
            chart: {
                type: 'area',
                stacked: false,
                height: '310px'
            },
            stroke: {
                width: [0, 3],
                curve: 'smooth'
            },
            plotOptions: {
                bar: {
                    columnWidth: '50%'
                }
            },
            colors: ['#00adad', '#67BAA7'],
            series: [{
        name: '@lang("Deposits")',
        type: 'area',
        data: @json($depositsChart['values'])
    }],
    fill: {
        opacity: [0.85, 1],
                },
    labels: @json($depositsChart['labels']),
    markers: {
        size: 0
    },
    xaxis: {
        type: 'text'
    },
    yaxis: {
        min: 0
    },
    tooltip: {
        shared: true,
            intersect: false,
                y: {
            formatter: function (y) {
                if (typeof y !== "undefined") {
                    return "$ " + y.toFixed(0);
                }
                return y;

            }
        }
    },
    legend: {
        labels: {
            useSeriesColors: true
        },
        markers: {
            customHTML: [
                function () {
                    return ''
                },
                function () {
                    return ''
                }
            ]
        }
    }
            }
    var chart = new ApexCharts(
        document.querySelector("#account-chart"),
        options
    );
    chart.render();
    }) ();
</script>
@endpush
