@extends($activeTemplate.'layouts.master')
@section('content')
<div class="body-wrapper">
    <div class="table-content">
        <div class="m-0">
            <div class="list-card">
                <div class="row search-dash justify-content-end mb-3">
                    <div class="col-xl-3 col-lg-5 col-md-6 col-10"> <input type="text" class="form--control"
                            name="search_table" placeholder="@lang('Search')...">
                        <i class="las la-search"></i>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <table class="custom-table">
                            <thead>
                                <tr>
                                    <th>@lang('Order No')</th>
                                    <th>@lang('Service Name')</th>
                                    <th>@lang('Link')</th>
                                    <th>@lang('Price')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($orders as $item)
                                <tr class="text-center">
                                    <td data-label="@lang('Order No')">#{{$item->order_no}}</td>
                                    <td data-label="@lang('Service Name')">
                                        @if(strlen(__(@$item->service->name)) >30)
                                        {{substr( __(@$item->service->name), 0,30).'...' }}
                                        @else
                                        {{__(@$item->service->name)}}
                                        @endif
                                    </td>
                                    <td data-label="@lang('Link')">
                                        <a href="{{$item->link}}" target="_blank" class="text--base">{{$item->link}}</a>
                                    </td>
                                    <td data-label="@lang('Price')">{{$general->cur_sym}}{{ showAmount($item->price) }}
                                    </td>
                                    <td data-label="@lang('Status')">
                                        @php
                                        echo $item->statusBadge($item->status);
                                        @endphp
                                    </td>

                                    <td data-label="@lang('Action')">
                                        <button class="btn btn--base btn--sm detailsModalBtn" data-start_count="{{$item->start_count}}" data-remains="{{$item->remains}}" data-name="{{@$item->service->name}}" title="@lang('Details')"><i class="fas fa-eye"></i></button>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%" data-label="@lang('Order Table')">
                                        {{__($emptyMessage) }}
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-5">
                        @if ($orders->hasPages())
                        <div class="py-4">
                            {{ paginateLinks($orders) }}
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


{{-- details modal --}}
<div id="detailsModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Order Details')</h5>
                <button type="button" class="close btn btn--sm btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="modal-body">
                    <p><strong>@lang('Service Name'):</strong> <span class="serviceName"></span></p>
                    <p><strong>@lang('Start Counter'):</strong> <span class="start_count"></span></p>
                    <p><strong>@lang('Remains'):</strong> <span class="remains"></span></p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script>
    (function ($) {
            "use strict";

            $('.detailsModalBtn').on('click', function () {
                var modal = $('#detailsModal');
                modal.find('.serviceName').text($(this).data('name'));
                modal.find('.start_count').text($(this).data('start_count'));
                modal.find('.remains').text($(this).data('remains'));
                modal.modal('show');
            });

            $('.custom-table').css('padding-top', '0px');
            var tr_elements = $('.custom-table tbody tr');

            $(document).on('input', 'input[name=search_table]', function () {
                "use strict";

                var search = $(this).val().toUpperCase();
                var match = tr_elements.filter(function (idx, elem) {
                    return $(elem).text().trim().toUpperCase().indexOf(search) >= 0 ? elem : null;
                }).sort();
                var table_content = $('.custom-table tbody');
                if (match.length == 0) {
                    table_content.html('<tr><td colspan="100%" class="text-center">Data Not Found</td></tr>');
                } else {
                    table_content.html(match);
                }
            });

    })(jQuery);

</script>
@endpush
