<?php
    $testimonial = getContent('testimonial.content',true);
    $testimonialElements = getContent('testimonial.element',false);
?>
<!--========================== Testimonial Start ==========================-->
<section class="testimonial py-80">
    <div class="container">
        <div class="title">
            <h4> <?php echo e(__(@$testimonial->data_values->heading)); ?></h4>
            <p><?php echo e(__(@$testimonial->data_values->subheading)); ?></p>
        </div>
        <div class="testimonial-slider">
            <?php $__currentLoopData = $testimonialElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card">
                <div class="profile d-flex">
                    <div>
                        <img src="<?php echo e(getImage(getFilePath('testimonial').'/'.@$item->data_values->testimonial_image)); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                    </div>
                    <div>
                        <h5>
                            <?php if(strlen(__(@$item->data_values->name)) >20): ?>
                            <?php echo e(substr(__(@$item->data_values->name), 0,20).'...'); ?>

                            <?php else: ?>
                            <?php echo e(__(@$item->data_values->name)); ?>

                            <?php endif; ?>
                        </h5>
                        <p> <?php if(strlen(__(@$item->data_values->designation)) >30): ?>
                            <?php echo e(substr(__(@$item->data_values->designation), 0,30).'...'); ?>

                            <?php else: ?>
                            <?php echo e(__(@$item->data_values->designation)); ?>

                            <?php endif; ?>
                        </p>
                    </div>
                </div>
                <div class="content">
                    <p> <?php if(strlen(__(@$item->data_values->description)) >120): ?>
                        <?php echo e(substr(__(@$item->data_values->description), 0,120).'...'); ?>

                        <?php else: ?>
                        <?php echo e(__(@$item->data_values->description)); ?>

                        <?php endif; ?>
                    </p>
                </div>
                <div class="star">
                    <?php echo showRatings($item->data_values->star_count) ?>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<!--========================== Testimonial End ==========================-->
<?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/presets/themeTwo/sections/testimonial.blade.php ENDPATH**/ ?>