
<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="table-content">
        <div class="m-0">
            <div class="list-card">
                <div class="row search-dash justify-content-end mb-3">
                    <div class="col-xl-3 col-lg-5 col-md-6 col-10"> <input type="text" class="form--control"
                            name="search_table" placeholder="<?php echo app('translator')->get('Search'); ?>...">
                        <i class="las la-search"></i>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <table class="custom-table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Package Name'); ?></th>
                                    <th><?php echo app('translator')->get('Link'); ?></th>
                                    <th><?php echo app('translator')->get('Price'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $brandPackageOrder; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td data-label="<?php echo app('translator')->get('Brand Package Name'); ?>"><?php echo e(__($item->name)); ?></td>

                                    <?php if($item->link): ?>
                                    <td data-label="<?php echo app('translator')->get('Links'); ?>">
                                        <?php $__currentLoopData = json_decode($item->link); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e($value); ?>" target="_blank"><?php echo e($value); ?></a>
                                        <br><br>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                    <?php endif; ?>

                                    <td data-label="<?php echo app('translator')->get('Price'); ?>"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($item->price)); ?>

                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                        <?php
                                        echo $item->statusBadge($item->status);
                                        ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%" data-label="Package Table">
                                        <?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-5">
                        <?php if($brandPackageOrder->hasPages()): ?>
                        <div class="py-4">
                            <?php echo e(paginateLinks($brandPackageOrder)); ?>

                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    (function ($) {
            "use strict";

            $('.custom-table').css('padding-top', '0px');
            var tr_elements = $('.custom-table tbody tr');

            $(document).on('input', 'input[name=search_table]', function () {
                "use strict";

                var search = $(this).val().toUpperCase();
                var match = tr_elements.filter(function (idx, elem) {
                    return $(elem).text().trim().toUpperCase().indexOf(search) >= 0 ? elem : null;
                }).sort();
                var table_content = $('.custom-table tbody');
                if (match.length == 0) {
                    table_content.html('<tr><td colspan="100%" class="text-center">Data Not Found</td></tr>');
                } else {
                    table_content.html(match);
                }
            });

    })(jQuery);

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/presets/themeTwo/user/orders/brand_package_order_index.blade.php ENDPATH**/ ?>