
<?php $__env->startSection('panel'); ?>
<div class="row mb-3">
    <div class="col-lg-12">
        <div class="d-flex flex-wrap gap-4 justify-content-end">
            <button type="button" class="btn btn-sm btn--primary mr-3 importbulkServiceBtn" data-toggle="modal" data-target="#importServiceModal" data-route="<?php echo e(route('admin.services.import.multi')); ?>"> <?php echo app('translator')->get('Import Bulk Service'); ?></button>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('ID'); ?></th>
                                <th><?php echo app('translator')->get('Name'); ?></th>
                                <th><?php echo app('translator')->get('Category'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $apiServiceLists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(__($service->service)); ?></td>
                                <td><?php echo e(\Str::limit($service->name, 30)); ?></td>
                                <td><?php echo e($service->category); ?></td>
                                <td>
                                    <button  data-route="<?php echo e(route('admin.services.import.single',['id'=>$service->service,'name'=>$service->name,'category'=>$service->category,'rate'=>$service->rate, 'dripfeed'=>@$service->dripfeed, 'min'=>$service->min,'max'=>$service->max,'provider'=>$provider->id])); ?>" class="btn btn--primary btn-sm singleServiceImportBtn"> <i class="fas fa-plus"></i><?php echo app('translator')->get('Add'); ?></button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table><!-- table end -->
                </div>
                <div class="p-5">
                    <?php if($apiServiceLists->hasPages()): ?>
                    <div class="card-footer">
                        <?php echo e(paginateLinks($apiServiceLists)); ?>

                    </div>
                <?php endif; ?>
                </div>
            </div>
        </div><!-- card end -->
    </div>
</div>


<div class="modal fade" id="importbulkServiceModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Bulk Service Imported'); ?></h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="" method="post" id="importMultipleForm">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="provider_id" value="<?php echo e($provider->id); ?>">
                <div class="modal-body">
                    <p><?php echo app('translator')->get('Are you really want to Import Service'); ?></p>
                    <div class="form-group">
                        <label><?php echo app('translator')->get('Bulk add limit'); ?></label>
                        <select class="form-control" name="import_quantity">
                            <?php for($loop = 25; $loop <= 1000; $loop+=25): ?>
                                <option value="<?php echo e($loop); ?>"><?php echo e($loop); ?></option>
                            <?php endfor; ?>
                            <option value="all"><?php echo app('translator')->get('All Services'); ?></option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label><?php echo app('translator')->get('how much percentage increase to apply to the base price?'); ?> <span class="text-danger">(<?php echo app('translator')->get('default 10%'); ?>)</span> </label>
                        <input type="text" name="percentage" class="form-control" placeholder="%">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary"><i class="fas fa-search"></i> <?php echo app('translator')->get('Confirm Import'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>


<div class="modal fade" id="singleServiceImportModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog " role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Bulk Service Imported'); ?></h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="" method="post" id="singleimportMultipleForm">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="provider_id" value="<?php echo e($provider->id); ?>">
                <div class="modal-body">
                    <p><?php echo app('translator')->get('Are you really want to Import Service'); ?></p>
                    <div class="form-group">
                        <label><?php echo app('translator')->get('Select Percentage Increase'); ?></label>
                        <select class="form-control" name="price_percentage_increase">
                            <?php for($percentage = 1; $percentage <= 100; $percentage++): ?>
                            <option value="<?php echo e($percentage); ?>"><?php echo e($percentage); ?> %</option>
                            <?php endfor; ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary"><i class="fas fa-search"></i> <?php echo app('translator')->get('Confirm Import'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>

        $(document).ready(function () {
            'use strict'
             // bulk service import
            $('.importbulkServiceBtn').on('click', function () {
                var modal = $('#importbulkServiceModal');
                let route = $(this).data('route');
                $('#importMultipleForm').attr('action', route);
                modal.modal('show');
            });

            // single service Import
            $('.singleServiceImportBtn').on('click', function () {
                var modal = $('#singleServiceImportModal');
                let route = $(this).data('route');
                $('#singleimportMultipleForm').attr('action', route);
                modal.modal('show');
            });

        });
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/admin/services/show_api_services.blade.php ENDPATH**/ ?>